#include <bits/stdc++.h>
using namespace std;

using ll = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<ll> x(n), y(n);
    for (int i = 0; i < n; i++) cin >> x[i] >> y[i];

    unordered_map<ll, ll> Y_even, Y_odd;   // ?? ??????? ?????–???: ????????? ?? y
    unordered_map<ll, ll> X_even, X_odd;   // ?? ??????? ?????–?????: ????????? ?? x
    unordered_map<ll, ll> S;               // S = x + y
    unordered_map<ll, ll> D;               // D = x - y

    Y_even.reserve(n*2);
    Y_odd.reserve(n*2);
    X_even.reserve(n*2);
    X_odd.reserve(n*2);
    S.reserve(n*2);
    D.reserve(n*2);

    for (int i = 0; i < n; i++) {
        ll xi = x[i], yi = y[i];

        // ?????–???: ???? y, ??????? x ???? ?? ?? ???????
        if ((xi & 1LL) == 0) Y_even[yi]++;
        else                Y_odd[yi]++;

        // ?????–?????: ???? x, ??????? y ???? ?? ?? ???????
        if ((yi & 1LL) == 0) X_even[xi]++;
        else                X_odd[xi]++;

        // ??????????
        S[xi + yi]++;
        D[xi - yi]++;
    }

    long long ans = 0;

    // ?????–???
    for (auto &kv : Y_even) {
        ll c = kv.second;
        ans += c * (c - 1) / 2;
    }
    for (auto &kv : Y_odd) {
        ll c = kv.second;
        ans += c * (c - 1) / 2;
    }

    // ?????–?????
    for (auto &kv : X_even) {
        ll c = kv.second;
        ans += c * (c - 1) / 2;
    }
    for (auto &kv : X_odd) {
        ll c = kv.second;
        ans += c * (c - 1) / 2;
    }

    // S-??????????: ????? ??? ???? *???* ????????
    for (auto &kv : S) {
        ll c = kv.second;
        ans += c * (c - 1);        // 2 * C(c,2)
    }

    // D-??????????: ?????? ?? ??? ????????
    for (auto &kv : D) {
        ll c = kv.second;
        ans += c * (c - 1);
    }

    cout << ans << "\n";
    return 0;
}